class MH2_Pickup_Armor2 extends MH2_Pickup;

#exec TEXTURE IMPORT NAME=Skin_Armor2 FILE=Textures\Skin_Armor2.bmp Group=Pickups MIPS=ON

function bool HandlePickupQuery( inventory Item )
{
local inventory Inv;

	if ( item.class == class ) 
		{
		
		Charge = Item.Charge;
			
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;				
		}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);

	return Copy;
}

defaultproperties
{
     bDisplayableInv=True
     PickupMessage="You got the Body Armor."
     ItemName="Body Armor"
     RespawnTime=30.000000
     PickupViewMesh=LodMesh'Botpack.Armor2M'
     Charge=100
     ArmorAbsorption=75
     bIsAnArmor=True
     AbsorptionPriority=7
     MaxDesireability=2.000000
     PickupSound=Sound'Botpack.Pickups.ArmorUT'
     Mesh=LodMesh'Botpack.Armor2M'
     AmbientGlow=64
     CollisionHeight=11.000000
     MultiSkins(1)=Texture'Skin_Armor2'
}
